	% Example 9.3
	% Step-invarinat design
	
	wc = 1;  ws = 5; Amax = 0.5; 	Amin = 40; 	
	N = CH_ORDER_S(wc, ws, Amax, Amin);
	N = 3;
	[G, Z, R_ZEROS, P, Wsnew] = CH_I_POLES_S(wc, ws, Amax, Amin, N);
	

	P = [0; P]
	[Residues, P, Mult] = PART_FRACT_EXPANSION(G, Z, P)
	 
	figure(1)
	t_axis = [0:0.001:30];
	[s_of_t, t_axis] = PZ_2_STEP_RESPONSE_S(G, Z, P, t_axis);
	PLOT_STEP_RESPONSE_S(s_of_t, t_axis)
	T = 1;
	[G, Z, P] = STEP_INVARIANT(G, Z, P, T)	
	wT = linspace(0, pi, 1000);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	Att = PZ_2_ATT_Z(G, Z, P, wT); 
	figure(2); axis_Amax = 40; axis_Tg_max= 8;
	subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 3.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(0.7, 1.1,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	

	
